﻿<%@ Assembly Name="$SharePoint.Project.AssemblyFullName$" %>
<%@ Import Namespace="Microsoft.SharePoint.ApplicationPages" %>
<%@ Register TagPrefix="SharePoint" Namespace="Microsoft.SharePoint.WebControls"
   Assembly="Microsoft.SharePoint, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %>
<%@ Register TagPrefix="Utilities" Namespace="Microsoft.SharePoint.Utilities" Assembly="Microsoft.SharePoint, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %>
<%@ Register TagPrefix="asp" Namespace="System.Web.UI" Assembly="System.Web.Extensions, Version=3.5.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" %>
<%@ Import Namespace="Microsoft.SharePoint" %>
<%@ Assembly Name="Microsoft.Web.CommandUI, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %>

<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ECMAScriptApplicationPage.aspx.cs"
   Inherits="ECMAScriptApplicationPage.Layouts.ECMAScriptApplicationPage.ECMAScriptApplicationPage"
   DynamicMasterPageFile="~masterurl/default.master" %>

<asp:Content ID="PageHead" ContentPlaceHolderID="PlaceHolderAdditionalPageHead" runat="server">
   <sharepoint:scriptlink id="scriptLink" runat="server" name="sp.js" loadafterui="true"
      localizable="false" />
   <script language="ecmascript" type="text/ecmascript">

      function GetWebsiteInfo() {

         // ClientContext holen
         var clientContext = new SP.ClientContext.get_current();

         // Web-Objekt abfragen
         this.web = clientContext.get_web();
         clientContext.load(this.web);

         // Listen laden
         this.lists = web.get_lists();
         clientContext.load(this.lists);

         // Abfrage asynchron ausführen
         clientContext.executeQueryAsync(
            Function.createDelegate(this, this.onQuerySucceeded),
            Function.createDelegate(this, this.onQueryFailed));
      }

      function onQuerySucceeded(sender, args) {

         // Hole den Titel und die Beschreibung
         var tite = this.web.get_title();
         var description = this.web.get_description();

         // Hole die Collection der Listen
         var listEnumerator = this.lists.getEnumerator();
         var lists;

         // Listen iterieren
         while (listEnumerator.moveNext()) {
            var listItem = listEnumerator.get_current();
            var listTitle = listItem.get_title();
            lists = lists + '> ' + listTitle.toString() + '\n';
         }

         // Daten ausgeben
         alert('Titel: ' + tite + '\n' +
         'Beschreibung: ' + description + '\n' +
         'Listen: ' + '\n' + lists);

      }

      function onQueryFailed(sender, args) {
         alert('Aufruf fehlgeschlagen ' +
         args.get_message() + '\n' +
         args.get_stackTrace());
      }
   </script>
</asp:Content>
<asp:Content ID="Main" ContentPlaceHolderID="PlaceHolderMain" runat="server">
   <input type="button" value="Website Infos anzeigen" onclick="GetWebsiteInfo()" />
</asp:Content>
<asp:Content ID="PageTitle" ContentPlaceHolderID="PlaceHolderPageTitle" runat="server">
   Application Page
</asp:Content>
<asp:Content ID="PageTitleInTitleArea" ContentPlaceHolderID="PlaceHolderPageTitleInTitleArea"
   runat="server">
   My Application Page
</asp:Content>